package main

import (
	"github.com/veandco/go-sdl2/sdl"
)

type Particle struct {
	rectangle sdl.Rect
	alive     bool
	aliveTime float32
	timeLeft  float32
	red       uint8
	green     uint8
	blue      uint8
	originX   float32
	originY   float32
	currentX  float32
	currentY  float32
	velocityX float32
	velocityY float32
}

func (particle *Particle) IsAlive() bool {
	return particle.alive
}

func (particle *Particle) Reset() {
	particle.alive = true
	particle.timeLeft = particle.aliveTime
	particle.currentX = particle.originX
	particle.currentY = particle.originY
}

func (particle *Particle) Update(deltaTime float32) {
	if !particle.alive {
		return
	}
	particle.timeLeft -= deltaTime
	if particle.timeLeft <= 0.0 {
		particle.alive = false
		return
	}
	particle.currentX += (particle.velocityX * deltaTime)
	particle.currentY += (particle.velocityY * deltaTime)
}

func (particle *Particle) Draw(renderer *sdl.Renderer) {
	particle.rectangle.X = int32(particle.currentX)
	particle.rectangle.Y = int32(particle.currentY)
	renderer.SetDrawColor(particle.red, particle.green, particle.blue, 255)
	renderer.FillRect(&particle.rectangle)
}
